/*
 Generated from https://non0reo.github.io/ImgToShader/
*/

#version 150

in vec4 vertexColor;

uniform vec4 ColorModulator;
uniform vec2 ScreenSize;

out vec4 fragColor;

void main() {
	vec4 color = vertexColor;
	vec2 uv = gl_FragCoord.xy / ScreenSize.xy;
	float bias = uv.y / 5;
	if (color.a == 0.0) {
		discard;
	}

	fragColor = color * ColorModulator;

	if (color.r == 239.0 / 255.0) {
		fragColor = vec4(0.2196078431372549 - bias, 0.0784313725490196, 0.26666666666666666, color.a);
	}

	if (color.r == 1.0 && color.a != 128.0 / 255.0) {
		fragColor = vec4(0.8196078431372549 + bias, 0.7058823529411765 + bias, 0.19607843137254902 + bias, color.a);
	}

	//if(uv.x >= 0.5) fragColor = vec4(0., 0., 1., 1.);
}	